<style>
/* Hide by default (for desktop/tablet) */
.tba-mobile-header,
.tba-mobile-nav {
  display: none;
}

/* Show only on mobile devices */
@media (max-width: 768px) {
  .tba-mobile-header,
  .tba-mobile-nav {
    display: flex; /* Now explicitly shown on mobile */
  }

  /* Header layout */
  .tba-mobile-header {
    justify-content: space-between;
    align-items: center;
    padding: 10px 15px;
    background-color: #fff;
    border-bottom: 1px solid #ddd;
    position: relative;
    z-index: 999;
  }

  /* Logo sizes */
  .tba-mobile-logo-left {
    height: 40px;
  }

  .tba-mobile-logo-right {
    height: 35px;
  }

  /* Nav layout */
  .tba-mobile-nav {
    justify-content: space-around;
    background-color: #fff;
    border-bottom: 2px solid #ddd;
    padding: 10px 0;
    flex-wrap: wrap;
  }

  .tba-mobile-nav a {
    font-weight: 400;
    font-size: 15px;
    color: #000;
    text-decoration: none;
  }
}

</style>
<?php
/**
 * Template part for displaying default header layout
 */
$header_type_page = consultio_get_page_opt( 'header_type', 'themeoption' );

$e_header_layout = consultio_get_opt('e_header_layout');
$e_header_layout_sticky = consultio_get_opt('e_header_layout_sticky');

$e_header_layout_page = consultio_get_page_opt('e_header_layout');
if($header_type_page == 'custom' ) {
    $e_header_layout = $e_header_layout_page;
}

$e_header_layout_sticky_page = consultio_get_page_opt('e_header_layout_sticky');
if($header_type_page == 'custom' ) {
    $e_header_layout_sticky = $e_header_layout_sticky_page;
}

$logo_m = consultio_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
$e_logo_mobile = consultio_get_page_opt( 'e_logo_mobile' );
if($header_type_page == 'custom' && !empty($e_logo_mobile['url']) ) {
    $logo_m = $e_logo_mobile;
}

if(class_exists('\Elementor\Plugin')){
    $id = get_the_ID();
    if ( is_singular() && \Elementor\Plugin::$instance->documents->get( $id )->is_built_with_elementor() ) {
        $classes = 'ct-header-content';
    } else {
        $classes = 'container';
    }
} else {
    $classes = 'container';
}

$h_address = consultio_get_opt( 'h_address', '' );
$h_address_label = consultio_get_opt( 'h_address_label', '' );
$h_phone = consultio_get_opt( 'h_phone', '' );
$h_phone_label = consultio_get_opt( 'h_phone_label', '' );
$h_phone_link = consultio_get_opt( 'h_phone_link', '' );
$h_phone_link_target = consultio_get_opt( 'h_phone_link_target', '_self' );
$h_address_link = consultio_get_opt( 'h_address_link', '' );
$h_address_link_target = consultio_get_opt( 'h_address_link_target', '_self' );
$h_email = consultio_get_opt( 'h_email', '' );
$h_email_label = consultio_get_opt( 'h_email_label', '' );
$h_email_link = consultio_get_opt( 'h_email_link', '' );
$h_email_link_target = consultio_get_opt( 'h_email_link_target', '_self' );

$h_btn_on = consultio_get_opt( 'h_btn_on', 'hide' );
$h_btn_text = consultio_get_opt( 'h_btn_text' );
$h_btn_link_type = consultio_get_opt( 'h_btn_link_type', 'page' );
$h_btn_link = consultio_get_opt( 'h_btn_link' );
$h_btn_link_custom = consultio_get_opt( 'h_btn_link_custom' );
$h_btn_target = consultio_get_opt( 'h_btn_target', '_self' );
if($h_btn_link_type == 'page') {
    $h_btn_url = get_permalink($h_btn_link);
} else {
    $h_btn_url = $h_btn_link_custom;
}

?>
<header id="ct-header-elementor" class="is-sticky">
	<?php if(isset($e_header_layout) && !empty($e_header_layout)) : ?>
		<div class="ct-header-elementor-main">
		    <div class="ct-header-content">
		        <div class="row">
		        	<div class="col-12">
			            <?php $post_main = get_post($e_header_layout);
	                    if (!is_wp_error($post_main) && $post_main->ID == $e_header_layout && class_exists('Case_Theme_Core') && function_exists('ct_print_html')){
	                        $content_main = Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $e_header_layout );
	                        ct_print_html($content_main);
	                    } ?>
	                </div>
		        </div>
		    </div>
		</div>
	<?php endif; ?>
	<?php if(isset($e_header_layout_sticky) && !empty($e_header_layout_sticky)) : ?>
		<div class="ct-header-elementor-sticky">
		    <div class="container">
		        <div class="row">
		            <?php $post_sticky = get_post($e_header_layout_sticky);
	                    if (!is_wp_error($post_sticky) && $post_sticky->ID == $e_header_layout_sticky && class_exists('Case_Theme_Core') && function_exists('ct_print_html')){
	                        $content_sticky = Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $e_header_layout_sticky );
	                        ct_print_html($content_sticky);
	                    } ?>
		        </div>
		    </div>
		</div>
	<?php endif; ?>
<!-- Mobile Header -->
<div class="tba-mobile-header">
  <img class="tba-mobile-logo-left" src="https://tba.bedots.site/wp-content/uploads/2025/07/Group-2.png" alt="TBA Logo">
  <img class="tba-mobile-logo-right" src="https://tba.bedots.site/wp-content/uploads/2025/07/image-11.png" alt="Saud Bahwan Logo">
</div>

<!-- Mobile Navigation -->
<div class="tba-mobile-nav">
  <a href="https://tba.bedots.site/">Home</a>
  <a href="https://tba.bedots.site/#about">About</a>
  <a href="https://tba.bedots.site/#contact">Contact</a>
</div>

</header>