<?php
$default_settings = [
    'list' => '',
    'style' => 'style1',
    'column' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
?>
<?php if(isset($list) && !empty($list) && count($list)): ?>
    <div class="ct-list <?php echo esc_attr($style.' '.$column); ?>">
        <?php
        	foreach ($list as $key => $ct_list): 
            $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
            if ( ! empty( $ct_list['link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $ct_list['link']['url'] );

                if ( $ct_list['link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $ct_list['link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key );
            ?>
            <div class="ct-list-item <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
            	<div class="ct-list-icon">
                    <?php if($style == 'style9') { ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M11.6673 9.9987L3.33398 3.33203V16.6654L11.6673 9.9987Z" stroke="#FB995A" stroke-width="2" stroke-miterlimit="2"/>
                            <path d="M18.334 9.99935L8.33398 1.66602V18.3327L18.334 9.99935Z" stroke="#596EFF" stroke-width="2" stroke-miterlimit="2"/>
                        </svg>
                    <?php } else if($style == 'style10') { ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M9.99955 18.125C9.86375 18.125 9.73165 18.0807 9.62324 17.999C9.51483 17.9172 9.43602 17.8023 9.39872 17.6717L8.74955 15.3992C8.47049 14.4105 7.94252 13.5099 7.21609 12.7835C6.48967 12.0571 5.58907 11.5291 4.60038 11.25L2.32788 10.6009C2.19739 10.5635 2.08261 10.4846 2.0009 10.3762C1.91919 10.2678 1.875 10.1358 1.875 10C1.875 9.86429 1.91919 9.73224 2.0009 9.62384C2.08261 9.51544 2.19739 9.43659 2.32788 9.3992L4.60038 8.75004C5.58907 8.47098 6.48967 7.943 7.21609 7.21658C7.94252 6.49016 8.47049 5.58956 8.74955 4.60087L9.39872 2.32837C9.4361 2.19788 9.51495 2.0831 9.62335 2.00139C9.73175 1.91968 9.8638 1.87549 9.99955 1.87549C10.1353 1.87549 10.2673 1.91968 10.3757 2.00139C10.4841 2.0831 10.563 2.19788 10.6004 2.32837L11.2495 4.60087C11.5286 5.58956 12.0566 6.49016 12.783 7.21658C13.5094 7.943 14.41 8.47098 15.3987 8.75004L17.6712 9.3992C17.8017 9.43659 17.9165 9.51544 17.9982 9.62384C18.0799 9.73224 18.1241 9.86429 18.1241 10C18.1241 10.1358 18.0799 10.2678 17.9982 10.3762C17.9165 10.4846 17.8017 10.5635 17.6712 10.6009L15.3987 11.25C14.41 11.5291 13.5094 12.0571 12.783 12.7835C12.0566 13.5099 11.5286 14.4105 11.2495 15.3992L10.6004 17.6717C10.5631 17.8023 10.4843 17.9172 10.3759 17.999C10.2675 18.0807 10.1354 18.125 9.99955 18.125ZM4.77455 10L4.94122 10.0484C6.1344 10.3852 7.22127 11.0224 8.09796 11.8991C8.97465 12.7758 9.61186 13.8627 9.94872 15.0559L9.99705 15.2225L10.0454 15.0559C10.3822 13.8627 11.0195 12.7758 11.8961 11.8991C12.7728 11.0224 13.8597 10.3852 15.0529 10.0484L15.2196 10L15.0529 9.9517C13.8597 9.61485 12.7728 8.97764 11.8961 8.10095C11.0195 7.22426 10.3822 6.13739 10.0454 4.9442L9.99955 4.77587L9.95122 4.94254C9.61436 6.13573 8.97715 7.22259 8.10046 8.09928C7.22377 8.97597 6.1369 9.61318 4.94372 9.95004L4.77455 10Z" fill="currentColor"/>
                        </svg>
                    <?php } else { ?>
                        <i class="fac fac-check-circle"></i>
                    <?php } ?>
                </div>
            	<div class="ct-list-meta">
	            	<div class="ct-list-desc">
	            		<?php echo ct_print_html($ct_list['content'])?>
	            	</div>
                    <?php if ( ! empty( $ct_list['link']['url'] ) ) { ?>
                        <a class="item--link" <?php echo implode( ' ', [ $link_attributes ] ); ?>></a>
                    <?php } ?>
	            </div>
           </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
