<?php
use Elementor\Icons_Manager;
Icons_Manager::enqueue_shim();
$default_settings = [
    'active_section' => '',
    'ct_accordion' => '',
    'main_icon' => '',
    'icon_active' => '',
    'title_html_tag' => 'div',
    'ct_animate' => '',
    'btn_text' => '',
    'btn_link' => '',
    'style' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$html_id = ct_get_element_id($settings);
$active_section = intval($active_section);
$accordions = $widget->get_settings('ct_accordion');
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if ( ! empty( $btn_link['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $btn_link['url'] );

    if ( $btn_link['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $btn_link['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
if(!empty($accordions)) : ?>
    <div id="<?php echo esc_attr($html_id); ?>" class="ct-accordion layout4 <?php echo esc_attr($style.' '.$ct_animate); ?>">
        <?php foreach ($accordions as $key => $value):
            $is_active = ($key + 1) == $active_section;
            $_id = isset($value['_id']) ? $value['_id'] : '';
            $ac_title = isset($value['ac_title']) ? $value['ac_title'] : '';
            $ac_content = isset($value['ac_content']) ? $value['ac_content'] : '';

            $title_key = $widget->get_repeater_setting_key( 'ac_title', 'ct_accordion', $key );
            $widget->add_render_attribute( $title_key, [
                'class' => [ 'ct-ac-title-text' ],
            ] );
            $widget->add_inline_editing_attributes( $title_key, 'basic' );

            $content_key = $widget->get_repeater_setting_key( 'ac_content', 'ct_accordion', $key );
            $widget->add_render_attribute( $content_key, [
                'id' => $_id.$html_id,
                'class' => [ 'ct-ac-content' ],
            ] );
            if($is_active){
                $widget->add_render_attribute( $content_key, 'style', 'display:block;' );
            }
            $widget->add_inline_editing_attributes( $content_key, 'basic' );
            $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
            $has_icon = ! empty( $value['ct_icon'] );
            $widget->add_render_attribute( $icon_key, [
                'class' => $value['ct_icon'],
                'aria-hidden' => 'true',
            ] );
            ?>
            <div class="ct-accordion-item <?php echo esc_attr($is_active?'active':''); ?>">
                <<?php ct_print_html($title_html_tag); ?> class="ct-ac-title <?php echo esc_attr($is_active?'active':''); ?>" data-target="<?php echo esc_attr('#' . $_id.$html_id); ?>">
                    <a <?php ct_print_html($widget->get_render_attribute_string( $title_key )); ?>>
                        <div class="ct-icon-accordion-readmore">
                            <div class="ct-icon-accordion-inner">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <path d="M3.52924 6.86258C3.2689 7.12292 3.2689 7.54505 3.52924 7.80538C3.7896 8.06572 4.2117 8.06572 4.47206 7.80538L7.33398 4.94345L7.33398 12.6673C7.33398 13.0355 7.63245 13.334 8.00065 13.334C8.36885 13.334 8.66732 13.0355 8.66732 12.6673L8.66732 4.94345L11.5293 7.80538C11.7896 8.06572 12.2117 8.06572 12.4721 7.80538C12.7324 7.54505 12.7324 7.12292 12.4721 6.86258L8.47205 2.86258C8.21172 2.60225 7.78958 2.60225 7.52925 2.86258L3.52924 6.86258Z" fill="#202020"/>
                                </svg>
                            </div>
                        </div>
                        <div class="ct-ac-title-text">
                            <span class="title-text"><?php echo esc_html($ac_title); ?></span>
                            <div class="icon-wrapper">
                                <?php
                                    if($is_new):
                                        \Elementor\Icons_Manager::render_icon( $value['ct_icon'], [ 'aria-hidden' => 'true' ] );
                                ?>
                                <?php else: ?>
                                    <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                                <?php endif; ?>
                            </div>
                        </div>
                    </a>
                </<?php ct_print_html($title_html_tag); ?>>
                <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>>
                    <div class="ct-ac-title-content">
                        <?php echo esc_html($ac_title); ?>
                    </div>
                    <div class="ct-ac-content-body">
                        <div class="ct-ac-content-body-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M13.7071 5.29289C13.3166 4.90237 12.6834 4.90237 12.2929 5.29289C11.9024 5.68342 11.9024 6.31658 12.2929 6.70711L16.5858 11L5 11C4.44772 11 4 11.4477 4 12C4 12.5523 4.44772 13 5 13L16.5858 13L12.2929 17.2929C11.9024 17.6834 11.9024 18.3166 12.2929 18.7071C12.6834 19.0976 13.3166 19.0976 13.7071 18.7071L19.7071 12.7071C20.0976 12.3166 20.0976 11.6834 19.7071 11.2929L13.7071 5.29289Z" fill="black"/>
                            </svg>
                        </div>
                        <div class="ct-ac-content-body-text">
                            <?php echo wp_kses_post(nl2br($ac_content)); ?>
                        </div>
                    </div>
                    <?php if(isset($value['ac_image']) && !empty($value['ac_image']['url'])): ?>
                        <div class="ct-ac-content-image">
                            <img src="<?php echo esc_url($value['ac_image']['url']); ?>" alt="<?php echo esc_attr($ac_title); ?>">
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
            endforeach;
        ?>
    </div>
<?php endif; ?>