(function ($) {
    /**
     * @param $scope The Widget wrapper element as a jQuery element
     * @param $ The jQuery alias
     */
    var WidgetCTSemiCircleChartHandler = function ($scope, $) {
        const triggers = $scope.find(".ct-semi-circle-chart-tooltip-trigger");
        const tooltipArrow = $scope.find("#tooltip-arrow");
        const tooltipContent = $scope.find("#tooltip-content");
        const chartContainer = $scope.find(".ct-semi-circle-chart");
        const chartInner = $scope.find(".ct-semi-circle-chart-inner");
        const chart3 = $scope.find(".ct-semi-chart-3");

        tooltipContent.css("display", "block");
        tooltipArrow.css("display", "block");

        const chart3Height = chart3.height();

        tooltipContent.css({
            position: "absolute",
            top: -chart3Height - 150 + "px",
            zIndex: "101",
        });

        tooltipArrow.css({
            position: "absolute",
            zIndex: "99",
            bottom: "35px",
        });

        function isMobile() {
            return window.innerWidth < 768;
        }

        function showTooltip(trigger) {
            const triggerRect = trigger[0].getBoundingClientRect();
            const chartRect = chartContainer[0].getBoundingClientRect();
            const value = trigger.data("value");

            if (isMobile()) {
                tooltipContent.css({
                    left: "50%",
                    transform: "translateX(-50%)",
                });

                tooltipArrow.css("display", "none");
            } else {
                const relativeLeft =
                    (triggerRect.left - chartRect.left) / chartRect.width;

                tooltipArrow.css({
                    display: "block",
                    left: relativeLeft * 100 + "%",
                    transform: "translateX(-96.5%)",
                });

                tooltipContent.css({
                    left: triggerRect.left - chartRect.left - 214 + "px",
                    transform: "translateX(-100.5%)",
                });
            }

            tooltipContent
                .find(".ct-semi-circle-tooltip-content-value")
                .text(value);

            tooltipContent.addClass("show");
            tooltipArrow.addClass("show");
        }

        function hideTooltip() {
            tooltipContent.removeClass("show");
            tooltipArrow.removeClass("show");
        }

        triggers.on("mouseenter", function () {
            showTooltip($(this));
        });

        triggers.on("click", function (e) {
            e.stopPropagation();
            showTooltip($(this));
        });

        chartContainer.on("mouseleave", function () {
            hideTooltip();
        });

        $(document).on("click", function (event) {
            if (!$(event.target).closest(".ct-semi-circle-chart").length) {
                hideTooltip();
            }
        });

        $(window).on("load", function () {
            chartInner.css("zIndex", "1");
        });

        // Update on window resize
        $(window).on("resize", function () {
            if (tooltipContent.hasClass("show")) {
                const activeTrigger = $scope.find(
                    ".ct-semi-circle-chart-tooltip-trigger.active"
                );
                if (activeTrigger.length) {
                    showTooltip(activeTrigger);
                }
            }
        });
    };

    // Make sure you run this code under Elementor.
    $(window).on("elementor/frontend/init", function () {
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ct_semi_circle_chart.default",
            WidgetCTSemiCircleChartHandler
        );
    });
})(jQuery);
