<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_blur_block',
        'title' => esc_html__('Case Blur Block', 'consultio'),
        'icon' => 'eicon-posts-justified',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'consultio'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'quantity',
                            'label' => esc_html__('Quantity', 'consultio'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 6,
                        ),
                        array(
                            'name' => 'width',
                            'label' => esc_html__('Width', 'consultio'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'default' => [
                                'size' => 27,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .ct-blur-block .ct-blur-block__item' => 'width: {{SIZE}}{{UNIT}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'height',
                            'label' => esc_html__('Height', 'consultio'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'default' => [
                                'size' => 500,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .ct-blur-block .ct-blur-block__item' => 'height: {{SIZE}}{{UNIT}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'angle',
                            'label' => esc_html__('Angle', 'consultio'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'default' => [
                                'size' => 0,
                            ],
                            'range' => [
                                'deg' => [
                                    'min' => -360,
                                    'max' => 360,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-blur-block .ct-blur-block__item' => 'transform: rotate({{SIZE}}deg) !important;',
                            ],
                        ),
                        array(
                            'name' => 'ct_animate',
                            'label' => esc_html__('Case Animate', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => consultio_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'ct_animate_delay',
                            'label' => esc_html__('Case Animate Delay', 'consultio'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 0,
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);